/* -*-c++-*- Copyright (C) 2018 Advanced Driver Information Technology.
 *
 * This library is open source and may be redistributed and/or modified under
 * the terms of the OpenSceneGraph Public License (OSGPL) version 0.0 or
 * (at your option) any later version.  The full license is in LICENSE file
 * included with this distribution, and on the openscenegraph.org website.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * OpenSceneGraph Public License for more details.
*/
#ifndef WAYLANDBACKEND_WLCOMPOSITOR
#define WAYLANDBACKEND_WLCOMPOSITOR 1

#include <string>
#include <wayland-client.h>
#include <wayland-client-protocol.h>

#include "WLSurfaceEvent.hpp"
#include "WLInterface.hpp"

namespace WaylandBackend
{

class WLCompositor : public WLInterface
{
public:
    WLCompositor(struct wl_event_queue *eventQ);
    virtual ~WLCompositor();
    
    int init(struct wl_registry* registry, uint32_t name,
                 const char* interface, uint32_t version);
    uint32_t getWLID();
    std::string& getWLName();
    
    struct wl_surface * createSurface(WLSurfaceEvent *wlInputHandler);
    void destroySurface(struct wl_surface *wlSurface);
    
private:
    struct wl_compositor*       _wlCompositor;
    uint32_t                    _wlID;
    std::string                 _wlInterfaceName;
};

}

#endif

